DROP TABLE IF EXISTS `site_core_languages`;
CREATE TABLE `site_core_languages` (
  `lang_id` int(11) NOT NULL AUTO_INCREMENT,
  `lang_order` int(11) NOT NULL,
  `lang_code` varchar(3) NOT NULL,
  `lang_title` varchar(255) NOT NULL,
  `lang_status` int(1) NOT NULL,
  `lang_dir` varchar(3) NOT NULL,
  `lang_default` int(1) NOT NULL,
  `lang_locale` text NOT NULL,
  `lang_locale_date` varchar(10) NOT NULL,
  `lang_logo` int(1) NOT NULL,
  `lang_logo_inverted` int(1) NOT NULL,
  `lang_icon` varchar(255) NOT NULL,
  PRIMARY KEY (`lang_id`),
  UNIQUE KEY `lang_id` (`lang_id`),
  KEY `lang_code` (`lang_code`),
  KEY `lang_status` (`lang_status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_core_languages_vars`;
CREATE TABLE `site_core_languages_vars` (
  `var_id` int(11) NOT NULL AUTO_INCREMENT,
  `var_name` varchar(100) NOT NULL,
  `var_protected` int(1) NOT NULL,
  PRIMARY KEY (`var_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;


DROP TABLE IF EXISTS `site_core_languages_vars_lang`;
CREATE TABLE `site_core_languages_vars_lang` (
  `var_id` int(11) NOT NULL,
  `lang_id` int(11) NOT NULL,
  `var_value` text NOT NULL,
  KEY `var_id` (`var_id`),
  KEY `lang_id` (`lang_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;



INSERT INTO `site_core_languages` (`lang_id`, `lang_order`, `lang_code`, `lang_title`, `lang_status`, `lang_dir`, `lang_default`, `lang_locale`) VALUES
(1, 0, 'en', 'English', 1, 'ltr', 1, '');


INSERT INTO `site_core_languages_vars` (`var_id`, `var_name`, `var_protected`) VALUES
(1, 'COPYRIGHT', 0),
(2, 'BREADCRUMB_HOME', 0),
(3, 'SECONDS', 0),
(4, 'HOURS', 0),
(5, 'MINUTES', 0),
(6, 'DAYS', 0);



INSERT INTO `site_core_languages_vars_lang` (`var_id`, `lang_id`, `var_value`) VALUES
(1, 1, '&copy; {PUB:YEAR} Company. All rights reserved.'),
(2, 1, 'HOME'),
(3, 1, 'Seconds'),
(4, 1, 'Hours'),
(5, 1, 'Minutes'),
(6, 1, 'Days');

